const helper = require("../helpers/helper")
const models = require('../models');
const Sequelize = require("sequelize");
const { Op, fn, col } = Sequelize;
const database = require('../helper/db.js');

module.exports = function (io) {
  io.on('connection', socket => {
    console.log("Socket Is Connected .........");

    socket.on("connect_user", async (connect_listener) => {
      try {
        let check_user = await models.socket_users.findOne({
          where: {
            user_id: connect_listener.user_id,
          },
        });

        let create_socket_user;
        if (check_user) {
          create_socket_user = await models.socket_users.update(
            {
              is_online: 1,
              socket_id: socket.id,
            },
            {
              where: {
                user_id: connect_listener.user_id,
              },
            }
          );
        } else {
          create_socket_user = await models.socket_users.create({
            user_id: connect_listener.user_id,
            socket_id: socket.id,
            is_online: 1,
          });
        }

        let success_message = {
          success_message: "connected successfully",
        };
        socket.emit("connect_user", success_message);
      } catch (error) {
        console.log("========error", error);
      }
    });

    socket.on("disconnect_user", async (connect_listener) => {
      try {
        create_socket_user = await models.socket_users.update(
          {
            is_online: 0,
          },
          {
            where: {
              user_id: connect_listener.user_id,
            },
          }
        );
        success_message = {
          success_message: "Disconnected successfully",
        };
        socket.emit("disconnect_user", success_message);
      } catch (error) {
        console.log(">>>>>>ERROR1", error);
        throw error;
      }
    });

    socket.on("send_message", async (get_data) => {
      try {

        const find_blocked_user = await models.block_users.findOne({
          where: {
            user_by: get_data.sender_id,
            user_to: get_data.receiver_id,
          },
        });

        if (find_blocked_user) {
          let blockMsg = "You cannot send messages to this user as you have been blocked.";
          let response = {
            code: 403,
            message: msg
          }
          socket.emit("send_message", blockMsg);
          return
        }
        let chatConstant = await models.chat_constants.findOne({
          where: {
            [Op.or]: [
              {
                sender_id: get_data.sender_id,
                receiver_id: get_data.receiver_id,
              },
              {
                sender_id: get_data.receiver_id,
                receiver_id: get_data.sender_id,
              },
            ],
          }, raw: true
        });

        console.log("chatConstant", chatConstant);

        // if (chatConstant.deleted_id != 0 && chatConstant.deleted_id == get_data.sender_id) {
        // await models.chat_constants.update({
        //   deleted_id: 0
        // }, {
        //   where: {
        //     id: chatConstant.id
        //   }
        // });

        let createMessage;
        if (chatConstant) {
          createMessage = await models.messages.create({
            sender_id: get_data.sender_id,
            receiver_id: get_data.receiver_id,
            chat_constant_id: chatConstant.id,
            type: get_data.type ?? 0,
            message: get_data.message,
            thumbnail: get_data.thumbnail ? get_data.thumbnail : '',
          })

          await models.chat_constants.update(
            {
              deleted_id: 0,
              last_msg_id: createMessage.id,
            },
            {
              where: {
                id: chatConstant.id,
              },
            }
          );
        } else {
          let createChatConstant = await models.chat_constants.create({
            sender_id: get_data.sender_id,
            receiver_id: get_data.receiver_id,
          });

          createMessage = await models.messages.create({
            sender_id: get_data.sender_id,
            receiver_id: get_data.receiver_id,
            chat_constant_id: createChatConstant.id,
            type: get_data.type ?? 0,
            message: get_data.message,
            thumbnail: get_data.thumbnail ? get_data.thumbnail : '',
          })

          await models.chat_constants.update(
            {
              deleted_id: 0,
              last_msg_id: createMessage.id,
            },
            {
              where: {
                id: createChatConstant.id,
              },
            }
          );
        }

        let lastMessage = await models.messages.findOne({
          attributes: {
            include: [
              [
                Sequelize.literal(
                  "(SELECT name FROM users WHERE users.id = messages.sender_id)"
                ),
                "SenderName",
              ],
              [
                Sequelize.literal(
                  "(SELECT image FROM users WHERE users.id = messages.sender_id limit 1)"
                ),
                "SenderImage",
              ],
              [
                Sequelize.literal(
                  "(SELECT name FROM users WHERE users.id = messages.receiver_id)"
                ),
                "ReceiverName",
              ],
              [
                Sequelize.literal(
                  "(SELECT image FROM users WHERE users.id = messages.receiver_id limit 1)"
                ),
                "ReceiverImage",
              ],

              [
                Sequelize.literal(`(
                              CASE
                                WHEN (
                                  SELECT count(id)
                                  FROM block_users WHERE block_users.user_by =${get_data.sender_id} AND block_users.user_to = ${get_data.receiver_id}
                                ) > 0 THEN 1
                                ELSE 0
                              END
                            )`),
                "is_blocked",
              ],

              [
                Sequelize.literal(`(
                            CASE
                              WHEN (
                                SELECT count(id)
                                FROM block_users WHERE block_users.user_to = ${get_data.receiver_id} AND block_users.user_by = ${get_data.sender_id}
                              ) > 0 THEN 1
                              ELSE 0
                            END
                          )`),
                "is_blocked_by_other",
              ],

              [
                Sequelize.literal(`(
                              CASE
                                WHEN (
                                  SELECT count(id)
                                  FROM report_users WHERE report_users.user_by = ${get_data.sender_id} AND report_users.user_to = ${get_data.receiver_id}
                                ) > 0 THEN 1
                                ELSE 0
                              END
                            )`),
                "is_report",
              ],

              [
                Sequelize.literal(`(
                              CASE
                                WHEN (
                                  SELECT count(id)
                                  FROM report_users WHERE report_users.user_to = ${get_data.receiver_id} AND report_users.user_by = ${get_data.sender_id}
                                ) > 0 THEN 1
                                ELSE 0
                              END
                            )`),
                "is_report_by_other",
              ],

              [
                Sequelize.literal(`(
                            CASE
                              WHEN (
                                SELECT count(id)
                                FROM mute_users WHERE mute_users.user_by = ${get_data.sender_id} AND mute_users.user_to = ${get_data.receiver_id}
                              ) > 0 THEN 1
                              ELSE 0
                            END
                          )`),
                "is_muted",
              ],
            ],
          },
          where: {
            id: createMessage.id,
          },
        });
        let recevierDetails = await models.socket_users.findOne({
          where: {
            user_id: get_data.receiver_id,
          },
          raw: true,
        });

        let pushdata = {
          message: get_data.message,
          booking_id: get_data.booking_id ? get_data.booking_id : 0,
        };
        let fromUser = get_data.sender_id;
        let toUser = get_data.receiver_id;
        await chat_push(fromUser, toUser, pushdata);

        io.to(recevierDetails && recevierDetails.socket_id).emit("send_message", lastMessage);
        socket.emit("send_message", lastMessage);
      } catch (error) {
        console.log("========error", error);
        throw error;
      }
    });

    socket.on("blocked_user", async (data) => {
      try {
        if (data.status == 1) {
          var blockUser = await models.block_users.create({
            user_by: data.user_by,
            user_to: data.user_to,
          });

          const find_blocked_user = await models.block_users.findOne({
            where: {
              user_by: data.user_by,
              user_to: data.user_to,
            },
          });

          msg = "User blocked successfully";

          let get_id = await models.socket_users.findOne({
            where: {
              user_id: data.user_by,
            },
          });

          socket.emit("blocked_user", { msg, find_blocked_user });

          if (get_id) {
            io.to(get_id.socket_id).emit("blocked_user", {
              msg,
              find_blocked_user,
            });
          }
        } else {
          await models.block_users.destroy({
            where: {
              [Op.and]: [{ user_to: data.user_to }, { user_by: data.user_by }],
            },
          });
          const find_blocked_user = await models.block_users.findOne({
            where: {
              user_by: data.user_by,
              user_to: data.user_to,
            },
          });

          msg = "User Unblocked successfully";

          var blockUser = {};

          let get_id = await models.socket_users.findOne({
            where: {
              user_id: data.user_by,
            },
          });
          socket.emit("blocked_user", { msg, find_blocked_user });

          if (get_id) {
            io.to(get_id.socket_id).emit("blocked_user", {
              msg,
              find_blocked_user,
            });
          }
        }
      } catch (error) {
        console.log("error", error)
        throw error;
      }
    });

    socket.on("report_user", async function (data) {
      try {
        const find_reported_users = await models.report_users.create({
          user_by: data.user_by,
          user_to: data.user_to,
          comment: data.comment,
        });

        msg = "User reported successfully";

        socket.emit("report_user", { msg, find_reported_users });
      } catch (error) {
        console.log(">>>>>>>>>>>>>error", error);
        throw error;
      }
    });

    socket.on("read_message", async (get_data) => {
      try {
        let chat_constantdata = await models.chat_constants.findOne({
          where: {
            [Op.or]: [
              {
                sender_id: get_data.sender_id,
                receiver_id: get_data.receiver_id,
              },
              {
                sender_id: get_data.receiver_id,
                receiver_id: get_data.sender_id,
              },
            ],
          },
        });
        if (chat_constantdata) {
          const updateReadStatus = await models.messages.update(
            {
              is_delivered: 1,
            },
            {
              where: {
                chat_constant_id: chat_constantdata.id,
                receiver_id: get_data.sender_id,
              },
            }
          );

          let recevierDetails = await models.socket_users.findOne({
            where: {
              user_id: get_data.receiver_id,
            },
            raw: true,
          });

          io.to(recevierDetails && recevierDetails.socket_id).emit("read_message", updateReadStatus);

          // msg = "Read status updated successfully";
          // socket.emit("read_message", { msg, updateReadStatus });
        }
      } catch (error) {
        console.log(">>>>>>>>unread count", error);
      }
    });

    socket.on("update_booking_status", async (get_data) => {
      try {
        let response = {
          booking_id: get_data.booking_id,
          status: get_data.status,
          type: get_data.type,
        }
        let sendUpdate = await models.socket_users.findAll({
          where: {
            user_id: {
              [Op.in]: get_data.receiver_id,
            },
          },
        });

        for (i in sendUpdate) {
          io.to(sendUpdate[i].socket_id).emit("update_booking_status", {
            response,
          });
        }

        let msg = "Booking status updated successfully";
        socket.emit("update_booking_status", { response });
      } catch (error) {
        console.log(">>>>>>>>unread count", error);
      }
    });

    socket.on("clear_chat", async function (get_data) {
      try {

        var find_id = await models.messages.findAll({
          where: {
            deleted_id: 0,
            [Op.or]: [
              { sender_id: get_data.sender_id, receiver_id: get_data.receiver_id },
              { sender_id: get_data.receiver_id, receiver_id: get_data.sender_id },
            ],
          },
        });

        if (find_id.length > 0) {
          var clear_msg = await models.messages.update(
            {
              deleted_id: get_data.sender_id,
              is_delivered: 1,
            },
            {
              where: {
                [Op.or]: [
                  { sender_id: get_data.sender_id, receiver_id: get_data.receiver_id },
                  { sender_id: get_data.receiver_id, receiver_id: get_data.sender_id },
                ],
              },
            }
          );

          var clear_constant = await models.chat_constants.update(
            {
              deleted_id: get_data.sender_id,
            },
            {
              where: {
                [Op.or]: [
                  { sender_id: get_data.sender_id, receiver_id: get_data.receiver_id },
                  { sender_id: get_data.receiver_id, receiver_id: get_data.sender_id },
                ],
              },
            }
          );
        } else {
          var clear_msg = await models.messages.destroy({
            where: {
              [Op.or]: [
                { sender_id: get_data.sender_id, receiver_id: get_data.receiver_id },
                { sender_id: get_data.receiver_id, receiver_id: get_data.sender_id },
              ],
            },
          });
        }

        success_message = {
          success_message: "Chat Clear Successfully",
        };
        socket.emit("clear_chat", success_message);
      } catch (error) {
        throw error;
      }
    });
    socket.on("get_message", async (data) => {
      try {
        // console.log(data,'===========================');
        // const currentPage = data.page || 1;
        // const pageSize = data.pageSize || 10; 

        // const offset = (currentPage - 1) * pageSize;

        var findMessages = await models.messages.findAll({
          attributes: {
            include: [
              [Sequelize.literal('(SELECT name FROM users WHERE users.id  = messages.sender_id)'), 'User_Name'],
              [Sequelize.literal('(SELECT image FROM users WHERE users.id  = messages.sender_id)'), 'User_Image'],
              [Sequelize.literal('(SELECT name FROM users WHERE users.id  = messages.receiver_id)'), 'Receiver_Name'],
              [Sequelize.literal('(SELECT image FROM users WHERE users.id  = messages.receiver_id)'), 'Receiver_Image'],
              [Sequelize.literal('(SELECT is_online FROM socket_users WHERE socket_users.user_id  = messages.receiver_id)'), 'onlinestatus'],
              [Sequelize.literal('(SELECT count(id) FROM block_users WHERE block_users.user_by  = messages.receiver_id)'), 'block_to'],
              [Sequelize.literal('(SELECT count(id) FROM block_users WHERE block_users.user_to  = messages.receiver_id)'), 'block_by'],
            ]
          },
          where: {
            [Op.or]: [{
              sender_id: data.sender_id,
              receiver_id: data.receiver_id,
            }, {
              sender_id: data.receiver_id,
              receiver_id: data.sender_id,
            }],
            [Op.not]: [{
              deleted_id: data.sender_id
            }]
          },
          order: [['id', 'asc']],
          // offset: offset, 
          // limit: pageSize,
          raw: true
        });
        socket.emit("get_message_listner", findMessages)
      } catch (error) {
        console.log(error, ">>>>>>>>>>>>>>>>>>")
      }
    });
    socket.on("get_chat_list", async (data) => {
      try {
        var getChat = await database.query(
          `SELECT *,
            c.*,CASE WHEN m.sender_id = ${data.sender_id} THEN m.receiver_id WHEN m.receiver_id = ${data.sender_id} THEN m.sender_id END AS sender_id,
            c.*,CASE WHEN m.sender_id = ${data.sender_id} THEN m.receiver_id WHEN m.receiver_id = ${data.sender_id} THEN m.sender_id END AS users2id,
            IFNULL((SELECT message FROM messages WHERE id = c.last_msg_id AND deleted_id != ${data.sender_id}), '') as lastMessage,
            (SELECT name FROM users WHERE (m.sender_id = ${data.sender_id} AND m.receiver_id = users.id)OR
            (m.receiver_id = ${data.sender_id} AND m.sender_id = users.id)) as user_name,

            (SELECT role FROM users WHERE (m.sender_id = ${data.sender_id} AND m.receiver_id = users.id)OR
            (m.receiver_id = ${data.sender_id} AND m.sender_id = users.id)) as user_role,
            (SELECT is_online FROM socket_users WHERE(m.sender_id = ${data.sender_id} AND m.receiver_id = socket_users.user_id)
            OR (m.receiver_id = ${data.sender_id} AND m.sender_id = socket_users.user_id)) as onlinestatus,
            (SELECT image FROM users WHERE(m.sender_id = ${data.sender_id} AND m.receiver_id = users.id)
            OR (m.receiver_id = ${data.sender_id} AND m.sender_id = users.id)) as user_image,
            (SELECT created_at FROM messages WHERE id = c.last_msg_id) as created_at
            FROM chat_constants c LEFT JOIN messages m ON c.last_msg_id = m.id WHERE (c.sender_id = ${data.sender_id} OR c.receiver_id = ${data.sender_id}) AND c.deleted_id != ${data.sender_id} 
            ORDER BY m.updated_at DESC`,
          {
            model: models.messages,
            model: models.chat_constants,
            type: database.QueryTypes.SELECT,
            raw: true
          }
        );
        const selectedRole = data.type;
        for (let i in getChat) {
          if (getChat[i].user_role == selectedRole) {
            const msgcount = await models.messages.count({
              where: {
                sender_id: getChat[i].sender_id == data.sender_id ? getChat[i].receiver_id : getChat[i].sender_id,
                receiver_id: data.sender_id,
                is_delivered: 0
              },
              raw: true
            });
            getChat[i].message_count = msgcount;
          } else {
            delete getChat[i];
          }
        }
        getChat = getChat.filter(item => item !== null && item !== undefined);
        socket.emit("get_chat_list_listner", getChat);
      } catch (error) {
        console.log(error)
      }
    });
    socket.on("clear_chat_new", async function (get_data) {
      try {
        var find_id = await models.messages.findAll({
          where: {
            deleted_id: 0,
            [Op.or]: [
              { sender_id: get_data.sender_id, receiver_id: get_data.receiver_id },
              { sender_id: get_data.receiver_id, receiver_id: get_data.sender_id },
            ],
          }, raw: true
        });
        if (find_id != 0) {
          var clear_msg = await models.messages.update(
            {
              deleted_id: get_data.sender_id,
            },
            {
              where: {
                [Op.or]: [
                  { sender_id: get_data.sender_id, receiver_id: get_data.receiver_id },
                  { sender_id: get_data.receiver_id, receiver_id: get_data.sender_id },
                ],
              },
            }
          );
          var clear_constant = await models.chat_constants.update(
            {
              deleted_id: get_data.sender_id,
            },
            {
              where: {
                [Op.or]: [
                  { sender_id: get_data.sender_id, receiver_id: get_data.receiver_id },
                  { sender_id: get_data.receiver_id, receiver_id: get_data.sender_id },
                ],
              },
            }
          );
          // updateconstant = await chat_constant.update(
          //   {
          //     deleted_id: msg.userid,
          //   },
          //   {
          //     where: {
          //       [Op.or]: [
          //         { userid: msg.userid, user2id: msg.user2id },
          //         { userid: msg.user2id, user2id: msg.userid },
          //       ],
          //     },
          //   }
          // );
        } else {
          const clear_msg = await models.messages.destroy({
            where: {
              [Op.or]: [
                { sender_id: get_data.sender_id, receiver_id: get_data.receiver_id },
                { sender_id: get_data.receiver_id, receiver_id: get_data.sender_id },
              ],
              deleted_id: get_data.receiver_id,
            },
          });
          var clear_constant = await models.chat_constants.destroy(
            {
              deleted_id: get_data.sender_id,
            },
            {
              where: {
                [Op.or]: [
                  { sender_id: get_data.sender_id, receiver_id: get_data.receiver_id },
                  { sender_id: get_data.receiver_id, receiver_id: get_data.sender_id },
                ],
                deleted_id: get_data.receiver_id,
              },
            }
          );
          var clear_msg1 = await models.messages.update(
            {
              deleted_id: get_data.sender_id,
            },
            {
              where: {
                [Op.or]: [
                  { sender_id: get_data.sender_id, receiver_id: get_data.receiver_id },
                  { sender_id: get_data.receiver_id, receiver_id: get_data.sender_id },
                ],
              },
            }
          );
        }
        success_message = {
          success_message: "Chat Clear Successfully",
        };
        socket.emit("clear_chat_new", success_message);
      } catch (error) {
        throw error;
      }
    });

    /*****************************Live tracking Start********************************/
    socket.on("current_location", async (bookingDetails) => {
      try {

        // update current lat & long in bookings table
        let update = {
          current_lat: bookingDetails.current_lat,
          current_long: bookingDetails.current_long,
        };

        let updateBooking = await models.bookings.update(update, {
          where: {
            id: bookingDetails.booking_id,
          },
        });

        // Get booking details
        let bookings = await models.bookings.findOne({
          where: {
            id: bookingDetails.booking_id,
          },
          raw: true,
        });

        // Get reciver user socket key
        let getUserSocketKey = await models.socket_users.findOne({
          where: {
            user_id: bookings.user_id,
          },
        });

        console.log("getUserSocketKey", getUserSocketKey);
        console.log("getUserSocketKey.socket_id", getUserSocketKey.socket_id);

        socket
          .to(getUserSocketKey.socket_id)
          .emit("current_location", bookings);

        socket.emit("current_location", bookings);
        console.log("data inserted successfully");
      } catch (error) {
        console.log(">>>>>>send_message", error);
        throw error;
      }
    });

    socket.on("status_update", async (bookingDetails) => {
      try {
        // Update the booking status
        let update = {
          status: bookingDetails.status,
        };

        await models.bookings.update(update, {
          where: {
            id: bookingDetails.booking_id,
          },
        });

        // Fetch the updated booking details
        let bookings = await models.bookings.findOne({
          where: {
            id: bookingDetails.booking_id,
          },
          raw: true,
        });

        // Fetch user and driver data
        let userData = await models.users.findOne({
          where: { id: bookings.user_id },
          raw: true,
        });

        let driverData = await models.users.findOne({
          where: { id: bookings.driver_id },
          raw: true,
        });

        // Notification logic for status updates
        let message = '';
        if (bookingDetails.status == 2) {
          message = "Driver on the way";
        } else if (bookingDetails.status == 4) {
          message = "Your ride has been completed";

          // **Payment split logic for completed ride (status == 4)**
          const paymentAmount = parseFloat(bookings.price); // Get final price
          const commissionPercentage = 5; // Define admin commission (adjustable)
          const commissionAmount = (paymentAmount * commissionPercentage) / 100;
          const driverAmount = paymentAmount - commissionAmount;

          // **Update driver's wallet**
          const currentDriverWallet = parseFloat(driverData.wallet) || 0;
          const newDriverWalletBalance = currentDriverWallet + driverAmount;

          await models.users.update({
            wallet: newDriverWalletBalance,
          }, {
            where: { id: bookings.driver_id }
          });

          // **Update admin's wallet with commission**
          const admin = await models.users.findOne({
            where: { role: 0, id: 1 }, // Assuming admin user is role 0
            attributes: ['wallet'],
            raw: true
          });

          const adminWallet = parseFloat(admin.wallet) || 0;
          const newAdminWalletBalance = adminWallet + commissionAmount;

          await models.users.update({
            wallet: newAdminWalletBalance,
          }, {
            where: { role: 0, id: 1 }
          });

          // **Update the commission field in the bookings table**
          await models.bookings.update({
            commission: commissionAmount,
          }, {
            where: { id: bookingDetails.booking_id },
          });
        } else if (bookingDetails.status == 5) {
          message = "Driver has reached your location";
        }

        // Send notification to the user
        let type = 6;
        let device_token = userData.device_token;
        let device_type = userData.device_type;

        let notificationData = {
          sender_id: bookings.driver_id,
          receiver_id: bookings.user_id,
          user_type: userData.role,
          message: message,
          type: type,
          booking_id: bookingDetails.booking_id,
          device_token: device_token,
          device_type: device_type,
        };

        if (device_token) {
          helper.sendPushToAndroid(notificationData);
        }

        // Emit the status update to the user
        let getUserSocketKey = await models.socket_users.findOne({
          where: { user_id: bookings.user_id },
        });

        socket.to(getUserSocketKey.socket_id).emit("status_update", bookings);
        socket.emit("status_update", bookings);

        console.log("Data updated and notification sent successfully.");
      } catch (error) {
        console.log(">>>>>>send_message", error);
        throw error;
      }
    });
  })



  async function chat_push(fromUser, toUser, pushdata) {
    try {
      // send push
      let from = await models.users.findOne({
        where: {
          id: fromUser,
        },
      });

      let to = await models.users.findOne({
        where: {
          id: toUser,
        },
      });

      if (to.device_type && to.device_token) {
        // 1=>IOS 2=>Android

        // let message = `${from.first_name} ${from.last_name} sent a message : ${pushdata.message}`;
        let message = "You have got new message";
        let type = 2;
        let booking_id = pushdata.booking_id;
        let device_token = to.device_token;
        let device_type = to.device_type;

        let data = {
          sender_id: from.id,
          receiver_id: to.id,
          user_type: to.role,
          message: message,
          type: type,
          booking_id: booking_id,
          post_id: 0,
          device_token: device_token,
          device_type: device_type,
        };

        if (to.device_type == 1) {
          if (to.role == 3 && to.is_notification == 1) {
            helper.sendPushToIos(data);
          } else {
            helper.sendPushToIos(data);
          }

        }

        if (to.device_type == 2) {
          if (to.role == 3 && to.is_notification == 1) {
            helper.sendPushToAndroid(data);
          } else {
            helper.sendPushToAndroid(data);
          }
        }
      }
    } catch (error) {
      console.log(">>>>>>>>>>>>>>>>>", error);
    }
  }


};
