socket.on("status_update", async (bookingDetails) => {
    try {

        // update current lat & long in bookings table
        //2=>ongoing, 4=>completed, 5=> reached
        let update = {
            status: bookingDetails.status,
        };

        let updateBooking = await models.bookings.update(update, {
            where: {
                id: bookingDetails.booking_id,
            },
        });

        // Get booking details
        let bookings = await models.bookings.findOne({
            where: {
                id: bookingDetails.booking_id,
            },
            raw: true,
        });

        // Get reciver user socket key
        let getUserSocketKey = await models.socket_users.findOne({
            where: {
                user_id: bookings.user_id,
            },
        });

        let userData = await models.users.findOne({
            where: {
                id: bookings.user_id
            },
            raw: true
        })
        let message = '';
        if (bookingDetails.status == 2) {
            message = "Driver on the way";
        } else if (bookingDetails.status == 4) {
            message = "Your ride has been completed";
        } else if (bookingDetails.status == 5) {
            message = "Driver has been reached on your location";
        }

        let type = 6;
        let booking_id = bookingDetails.booking_id;
        let device_token = userData.device_token;
        let device_type = userData.device_type;

        let notificationData = {
            sender_id: bookings.driver_id,
            receiver_id: bookings.user_id,
            user_type: userData.role,
            message: message,
            type: type,
            booking_id: booking_id,
            device_token: device_token,
            device_type: device_type,
        };

        if (device_token) {
            helper.sendPushToAndroid(notificationData);
        }

        socket
            .to(getUserSocketKey.socket_id)
            .emit("status_update", bookings);

        socket.emit("status_update", bookings);
        console.log("data inserted successfully");
    } catch (error) {
        console.log(">>>>>>send_message", error);
        throw error;
    }
});