const Sequelize = require('sequelize');
module.exports = function (sequelize, DataTypes) {
  const users = sequelize.define('users', {
    id: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    role: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 2,
      comment: "0=>Admin,1=>Driver,2=>User,3=>subadmin"
    },
    first_name: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    last_name: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    email: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    social_type: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "1=>facebook,2=>google,3=>apple"
    },
    social_id: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: "0"
    },
    email_verified_at: {
      type: DataTypes.DATE,
      allowNull: true
    },
    password: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    country_code: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    phone_number: {
      type: DataTypes.STRING(20),
      allowNull: true
    },
    image: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    latitude: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: "0"
    },
    longitude: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: "0"
    },
    address: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    address_line_1: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: ""
    },
    address_line_2: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    zip_code: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    about: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    device_type: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 1,
      comment: "1=>ios,2=>Android,3=>Web"
    },
    device_token: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    status: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "0=>InActive,1=>Active"
    },
    remember_token: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    commission: {
      type: DataTypes.DOUBLE(8, 2),
      allowNull: false,
      defaultValue: 0.00
    },
    wallet: {
      type: DataTypes.DOUBLE(8, 2),
      allowNull: false,
      defaultValue: 0.00
    },
    is_notification: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 1,
      comment: "0=>Off, 1=>On"
    },
    is_email_verified: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "0=>Pending, 1=>verified"
    },
    is_phone_verified: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "0=>pending, 1=>verified"
    },
    is_online: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "0=>offline, 1=>online"
    },
    email_otp: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: ""
    },
    phone_otp: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: ""
    },
    reset_token: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: ""
    },
    date_of_birth: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    gender: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 1,
      comment: "\"1=>Male,2=>Female,3=>Other\""
    },
    document_front: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    document_back: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    vehicle_type: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    color: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    driving_license: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    vehicle_no: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    registration_no: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    registration_file: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    driving_licence_file: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    state: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    city: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    is_profile_complete: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "0=>Not Complete, 1=>Complete"
    },
    model_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
    },
    allergies: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    medical_history: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    medical_treatment_duration: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    consulted_doctors: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    add_medical_details: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    add_treatment_duration: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    stripeId: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    stripeAccountHas: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    stripeAccountId: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    createdAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "created_at",
    },
    updatedAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "updated_at",
    },
    deletedAt: {
      type: DataTypes.DATE,
      allowNull: true,
      field: "deleted_at"
    }
  }, {
    sequelize,
    tableName: 'users',
    timestamps: true,
    paranoid: true,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id" },
        ]
      },
    ]
  });

  users.associate = function (models) {

    users.belongsTo(models.vehicle_types, {
      foreignKey: "vehicle_type",
      as: "vehicleType"
    });

    users.belongsTo(models.vehicle_models, {
      foreignKey: "model_id",
    });
  }


  return users
};
