const Sequelize = require('sequelize');
module.exports = function (sequelize, DataTypes) {
  const request_send_to_drivers = sequelize.define('request_send_to_drivers', {
    id: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    booking_id: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    driver_id: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    status: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "\"0=>Pending, 1=>Accept,2=>Cancel\""
    },
    createdAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "created_at",
    },
    updatedAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "updated_at",
    },
  }, {
    sequelize,
    tableName: 'request_send_to_drivers',
    timestamps: true,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id" },
        ]
      },
    ]
  });

  request_send_to_drivers.associate = function (models) {
    request_send_to_drivers.belongsTo(models.bookings, {
      foreignKey: "booking_id"
    });

    request_send_to_drivers.belongsTo(models.users, {
      foreignKey: "driver_id"
    });
  }

  return request_send_to_drivers
};
