const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('prices', {
    id: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    base_price: {
      type: DataTypes.FLOAT,
      allowNull: false,
      defaultValue: 0
    },
    per_mile: {
      type: DataTypes.FLOAT,
      allowNull: false,
      defaultValue: 0
    },
    per_minute: {
      type: DataTypes.FLOAT,
      allowNull: false,
      defaultValue: 0
    },
    booking_fee: {
      type: DataTypes.FLOAT,
      allowNull: false,
      defaultValue: 0
    },
    surge_charge: {
      type: DataTypes.FLOAT,
      allowNull: false,
      defaultValue: 0
    },
    createdAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "created_at",
    },
    updatedAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "updated_at",
    },
  }, {
    sequelize,
    tableName: 'prices',
    timestamps: true,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id" },
        ]
      },
    ]
  });
};
