const Sequelize = require('sequelize');
module.exports = function (sequelize, DataTypes) {
  const notifications = sequelize.define('notifications', {
    id: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    user_by: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    user_to: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    status: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "\"0=>Pending,1=>Accept,2=>Reject\""
    },
    comment: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    type: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0
    },
    is_read: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "\t\"0=>Read, 1=>UnRead\""
    },
    booking_id: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0
    },
    createdAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "created_at",
    },
    updatedAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "updated_at",
    },
  }, {
    sequelize,
    tableName: 'notifications',
    timestamps: true,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id" },
        ]
      },
    ]
  });

  notifications.associate = function (models) {
    notifications.belongsTo(models.users, {
      foreignKey: "user_by", as: "userby"
    });

    notifications.belongsTo(models.users, {
      foreignKey: "user_to", as: "userto"
    });

    notifications.belongsTo(models.bookings, {
      foreignKey: "booking_id"
    });
  }

  return notifications
};
