const Sequelize = require('sequelize');
module.exports = function (sequelize, DataTypes) {
  return sequelize.define('messages', {
    id: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    sender_id: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    receiver_id: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    chat_constant_id: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    type: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "\"0=>text, 1=>image, 2=>video, 3=>audio, 4=>doc\""
    },
    message: {
      type: DataTypes.TEXT,
      allowNull: false
    },
    thumbnail: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    deleted_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    is_delivered: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "0 => unread , 1=> read"
    },
    created: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: ""
    },
    updated: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: ""
    },
    createdAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "created_at",
    },
    updatedAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "updated_at",
    },
  }, {
    sequelize,
    tableName: 'messages',
    timestamps: true,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id" },
        ]
      },
    ],
    hooks: {
      beforeCreate: (record, options) => {
        record.created = Math.round(new Date().getTime() / 1000);
        record.updated = Math.round(new Date().getTime() / 1000);
      },
      beforeUpdate: (record, options) => {
        record.updated = Math.round(new Date().getTime() / 1000);
      },
      beforeBulkCreate: (records, options) => {
        if (Array.isArray(records)) {
          records.forEach((record) => {
            record.created = Math.round(new Date().getTime() / 1000);
            record.updated = Math.round(new Date().getTime() / 1000);
          });
        }
      },
      beforeBulkUpdate: (records, options) => {
        if (Array.isArray(records)) {
          records.forEach((record) => {
            record.updated = Math.round(new Date().getTime() / 1000);
          });
        }
      }
    }
  });
};
