const Sequelize = require('sequelize');

module.exports = function (sequelize, DataTypes) {
  return sequelize.define('chat_constants', {
    id: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    sender_id: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    receiver_id: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    last_msg_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    deleted_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    created: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: ""
    },
    updated: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: ""
    },
    createdAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "created_at",
    },
    updatedAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "updated_at",
    },
  }, {
    sequelize,
    tableName: 'chat_constants',
    timestamps: true,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id" },
        ]
      },
    ],
    hooks: {
      beforeCreate: (record, options) => {
        record.created = Math.round(new Date().getTime() / 1000);
        record.updated = Math.round(new Date().getTime() / 1000);
      },
      beforeUpdate: (record, options) => {
        record.updated = Math.round(new Date().getTime() / 1000);
      },
      beforeBulkCreate: (records, options) => {
        if (Array.isArray(records)) {
        records.forEach((record) => {
          record.created = Math.round(new Date().getTime() / 1000);
          record.updated = Math.round(new Date().getTime() / 1000);
        });
      }
      },
      beforeBulkUpdate: (records, options) => {
        if (Array.isArray(records)) {
        records.forEach((record) => {
          record.updated = Math.round(new Date().getTime() / 1000);
        });
      }
      }
    }
  });
};
