const Sequelize = require('sequelize');
module.exports = function (sequelize, DataTypes) {
  const bookings = sequelize.define('bookings', {
    id: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    driver_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    vehicle_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    destination_from: {
      type: DataTypes.STRING(255),
      allowNull: false
    },
    destination_from_lat: {
      type: DataTypes.STRING(255),
      allowNull: false
    },
    destination_from_long: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    destination_to: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    destination_to_lat: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    destination_to_long: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    no_of_person: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    is_schedule: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "\"1=>Schedule, 0=>Not Schedule\""
    },
    comment: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    booking_date: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    booking_time: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    price: {
      type: DataTypes.FLOAT,
      allowNull: false,
      defaultValue: 0
    },
    old_price: {
      type: DataTypes.FLOAT,
      allowNull: false,
      defaultValue: 0
    },
    coupon_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    current_lat: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    current_long: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    distance: {
      type: DataTypes.FLOAT,
      allowNull: false,
      defaultValue: 0
    },
    status: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "\"0=>pending,1=>accept,2=>ongoing,3=>Cancel,4=>Completed\""
    },
    payment_status: {
      type: DataTypes.TINYINT,
      allowNull: false,
      defaultValue: 0,
      comment: "0=>Pending, 1=>Completd, 2=>Cancel"
    },
    transaction_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    cancel_by: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    payment: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    stripe_status: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    commission: {
      type: DataTypes.FLOAT,
      allowNull: false,
      defaultValue: 0
    },
    tip_data: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    tip_stripe_status: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    tip: {
      type: DataTypes.FLOAT,
      allowNull: false,
      defaultValue: 0
    },
    tip_transaction_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    cancel_amount: {
      type: DataTypes.FLOAT,
      allowNull: false,
      defaultValue: 0
    },
    cancel_data: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    createdAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "created_at",
    },
    updatedAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      field: "updated_at",
    },
  }, {
    sequelize,
    tableName: 'bookings',
    timestamps: true,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id" },
        ]
      },
    ]
  });

  bookings.associate = function (models) {
    bookings.belongsTo(models.vehicle_types, {
      foreignKey: "vehicle_id"
    });

    bookings.belongsTo(models.users, {
      foreignKey: "user_id"
    });

    bookings.belongsTo(models.users, {
      foreignKey: "driver_id",
      as: "driver_details"
    });

    bookings.belongsTo(models.users, {
      foreignKey: "cancel_by",
      as: "cancelBy"
    });

    bookings.hasOne(models.ratings, {
      foreignKey: "booking_id",
    });
  }

  return bookings
};
