const helper = require('../helpers/helper')
const { Validator } = require('node-input-validator');
const jwt = require("jsonwebtoken");
const models = require('../models');

module.exports = {
    authenticateHeader: async function (req, res, next) {
        // console.log(req.headers, "--------in header check------------");
        const v = new Validator(req.headers, {
            secret_key: "required|string",
            publish_key: "required|string",
        });

        let errorsResponse = await helper.checkValidation(v);

        if (errorsResponse) {
            return helper.failed(res, errorsResponse);
        }

        if (
            req.headers.secret_key !== process.env.SECRET_KEY ||
            req.headers.publish_key !== process.env.PUBLISH_KEY
        ) {
            return helper.failed(res, "Key not matched!");
        }
        next();
    },

    authenticateJWT: async (req, res, next) => {
        const authHeader = req.headers.authorization;

        if (authHeader) {
            const token = authHeader.split(" ")[1];

            jwt.verify(token, process.env.CRYPTO_KEY, async (err, payload) => {
                if (err) {
                    return res.sendStatus(403);
                }

                const existingUser = await models.users.findOne({
                    where: {
                        id: payload.data.id,
                        // loginTime: payload.data.loginTime,
                    },
                });

                if (existingUser) {
                    req.user = existingUser;
                    next();
                } else {
                    res.sendStatus(401);
                }
            });
        } else {
            res.sendStatus(401);
        }
    },
};
