const models = require('../models');
const helper = require('../helpers/helper')
const { Validator } = require('node-input-validator');
const Sequelize = require("sequelize");
const { Op, fn, col } = Sequelize;

module.exports = {
    vehicleType: async (req, res) => {
        try {
            let vehicleTypes = await models.vehicle_types.findAll()
            return helper.success(res, "Vehicle Type", vehicleTypes);
        } catch (error) {
            console.log(">>>>error", error);
            return helper.failed(res, error);
        }
    },

    vehicleUpdate: async (req, res) => {
        try {
            let userDetails = await models.users.findOne({
                where: {
                    id: req.user.id
                }
            })

            let data = {}
            if (req.body.latitude) {
                data.latitude = req.body.latitude;
            }

            if (req.body.longitude) {
                data.longitude = req.body.longitude;
            }

            if (req.body.device_type) {
                data.device_type = req.body.device_type;
            }

            if (req.body.device_token) {
                data.device_token = req.body.device_token;
            }

            if (req.body.vehicle_type) {
                data.vehicle_type = req.body.vehicle_type;
            }

            if (req.body.vehicle_no) {
                data.vehicle_no = req.body.vehicle_no;
            }

            if (req.body.registration_no) {
                data.registration_no = req.body.registration_no;
            }

            if (req.body.color) {
                data.color = req.body.color;
            }

            if (req.body.model_id) {
                data.model_id = req.body.model_id;
            }

            if (req.body.driving_license) {
                data.driving_license = req.body.driving_license;
            }

            if (req.files && req.files.registration_file) {
                registration_file = helper.fileUpload(
                    req.files.registration_file,
                    "uploads",
                    "images"
                );
                data.registration_file = registration_file;
            }

            if (req.files && req.files.driving_licence_file) {
                driving_licence_file = helper.fileUpload(
                    req.files.driving_licence_file,
                    "uploads",
                    "images"
                );
                data.driving_licence_file = driving_licence_file;
            }
            await userDetails.update(data);

            userDetails = await models.users.findOne({
                where: {
                    id: req.user.id
                }
            })
            return helper.success(res, "Vehicle details updated successfully.", userDetails);
        } catch (error) {
            console.log(">>>>error", error);
            return helper.failed(res, error);
        }
    },

    vehicleModel: async (req, res) => {
        try {
            let vehicleTypes = await models.vehicle_models.findAll()
            return helper.success(res, "Vehicle Model", vehicleTypes);
        } catch (error) {
            console.log(">>>>error", error);
            return helper.failed(res, error);
        }
    },

};
