const models = require('../models');
const helper = require('../helpers/helper')
const { Validator } = require('node-input-validator');
const jwt = require("jsonwebtoken");
const bcrypt = require("bcrypt");

module.exports = {
    userSignUp: async (req, res) => {
        try {
            const v = new Validator(req.body, {
                first_name: "required",
                email: "required",
                password: "required",
                device_type: "required",
                device_token: "required",
            });
            const values = JSON.parse(JSON.stringify(v));
            let errorsResponse = await helper.checkValidation(v);

            if (errorsResponse) {
                return helper.failed(res, errorsResponse);
            }
            let checkEmail = await models.users.findOne({
                where: {
                    email: req.body.email
                }
            });

            if (checkEmail) {
                return helper.failed(res, 'Email already registered, Please try with another email!')
            }

            if (req.body.password) {
                req.body.password = await bcrypt.hash(req.body.password, 10);
            }
            let data = {
                role: req.body.role ? req.body.role : 2,
                first_name: req.body.first_name ?? '',
                last_name: req.body.last_name ?? '',
                email: req.body.email ?? '',
                password: req.body.password ?? '',
                country_code: req.body.country_code ?? '',
                phone_number: req.body.phone_number ?? '',
                latitude: req.body.latitude ?? '',
                longitude: req.body.longitude ?? '',
                address: req.body.address ?? '',
                address_line_1: req.body.address_line_1 ?? '',
                address_line_2: req.body.address_line_2 ?? '',
                zip_code: req.body.zip_code ?? '',
                about: req.body.about ?? '',
                device_type: req.body.device_type ?? '',
                device_token: req.body.device_token ?? '',
            }

            if (req.files && req.files.image) {
                image = helper.fileUpload(
                    req.files.image,
                    "uploads",
                    "images"
                );
                data.image = image;
            }
            let createUser = await models.users.create(data)
            if (createUser) {

                let userInfo = await models.users.findOne({
                    where: {
                        id: createUser.id
                    },
                    raw: true
                });

                let token = jwt.sign(
                    {
                        data: {
                            id: userInfo.id,
                            email: userInfo.email,
                            name: userInfo.name,
                            type: userInfo.type,
                            device_type: userInfo.device_type,
                            device_token: userInfo.device_token,
                        },
                    },
                    process.env.CRYPTO_KEY,
                    { expiresIn: "30d" }
                );

                userInfo.token = token
                let msg = "User registered successfully!"
                return helper.success(res, msg, userInfo)
            }
        } catch (error) {
            console.log(">>>>>>error", error);
            return helper.failed(res, error)
        }
    },

    userProfileUpdate: async (req, res) => {
        try {
            let userDetails = await models.users.findOne({
                where: {
                    id: req.user.id
                }
            })

            let data = {}

            if (req.body.first_name) {
                data.first_name = req.body.first_name;
            }

            if (req.body.last_name) {
                data.last_name = req.body.last_name;
            }

            if (req.body.email) {
                data.email = req.body.email;
            }

            if (req.body.password) {
                data.password = await bcrypt.hash(req.body.password, 10);
            }

            if (req.body.country_code) {
                data.country_code = req.body.country_code;
            }
            if (req.body.phone_number) {
                data.phone_number = req.body.phone_number;
            }

            if (req.body.latitude) {
                data.latitude = req.body.latitude;
            }

            if (req.body.longitude) {
                data.longitude = req.body.longitude;
            }

            if (req.body.device_type) {
                data.device_type = req.body.device_type;
            }

            if (req.body.device_token) {
                data.device_token = req.body.device_token;
            }

            if (req.body.vehicle_no) {
                data.vehicle_no = req.body.vehicle_no;
            }

            if (req.body.registration_no) {
                data.registration_no = req.body.registration_no;
            }

            if (req.files && req.files.image) {
                image = helper.fileUpload(
                    req.files.image,
                    "uploads",
                    "images"
                );
                data.image = image;
            }

            if (req.files && req.files.registration_file) {
                registration_file = helper.fileUpload(
                    req.files.registration_file,
                    "uploads",
                    "images"
                );
                data.registration_file = registration_file;
            }

            if (req.files && req.files.driving_licence_file) {
                driving_licence_file = helper.fileUpload(
                    req.files.driving_licence_file,
                    "uploads",
                    "images"
                );
                data.driving_licence_file = driving_licence_file;
            }

            if (req.body.model_id) {
                data.model_id = req.body.model_id;
            }

            data.is_profile_complete = 1;
            await userDetails.update(data);

            userDetails = await models.users.findOne({
                where: {
                    id: req.user.id
                }
            })
            return helper.success(res, "Profile updated successfully.", userDetails);
        } catch (error) {
            console.log(">>>>>>error", error);
            return helper.failed(res, error)
        }
    },

    userProfile: async (req, res) => {
        try {
            where = {}

            where.id = req.user.id


            let userDetails = await models.users.findOne({
                include: [
                    {
                        model: models.vehicle_types,
                        as: "vehicleType"
                    },
                    {
                        model: models.vehicle_models,
                    }
                ],
                where: where
            })
            return helper.success(res, "Profile details get successfully.", userDetails);
        } catch (error) {
            console.log(">>>>>>error", error);
            return helper.failed(res, error)
        }
    },

    updateCurrentDetails: async (req, res) => {
        try {
            let userDetails = await models.users.findOne({
                where: {
                    id: req.user.id
                }
            })

            let data = {}

            if (req.body.latitude) {
                data.latitude = req.body.latitude;
            }

            if (req.body.longitude) {
                data.longitude = req.body.longitude;
            }

            if (req.body.is_online) {
                data.is_online = req.body.is_online;
            }
            await userDetails.update(data);

            userDetails = await models.users.findOne({
                where: {
                    id: req.user.id
                }
            })
            return helper.success(res, "Profile updated successfully.", userDetails);
        } catch (error) {
            console.log(">>>>>>error", error);
            return helper.failed(res, error)
        }
    },

    medicalDetailsUpdate: async (req, res) => {
        try {
            let userDetails = await models.users.findOne({
                where: {
                    id: req.user.id
                }
            })

            let data = {}

            if (req.body.allergies) {
                data.allergies = req.body.allergies;
            }

            if (req.body.medical_history) {
                data.medical_history = req.body.medical_history;
            }

            if (req.body.medical_treatment_duration) {
                data.medical_treatment_duration = req.body.medical_treatment_duration;
            }

            if (req.body.consulted_doctors) {
                data.consulted_doctors = req.body.consulted_doctors;
            }

            if (req.body.add_medical_details) {
                data.add_medical_details = req.body.add_medical_details;
            }

            if (req.body.add_treatment_duration) {
                data.add_treatment_duration = req.body.add_treatment_duration;
            }

            await userDetails.update(data);

            userDetails = await models.users.findOne({
                where: {
                    id: req.user.id
                }
            })
            return helper.success(res, "Medical details updated successfully.", userDetails);
        } catch (error) {
            console.log(">>>>>>error", error);
            return helper.failed(res, error)
        }
    },

    price : async(req,res) => {
        try {
            let price = await models.prices.findOne({
                where: {
                    id: 1
                }
            })

            return helper.success(res, "Price list.", price);

        } catch (error) {
            console.log(">>>>>>error", error);
            return helper.failed(res, error)
        }
    }

};
