const models = require('../models');
const helper = require('../helpers/helper')
const { Validator } = require('node-input-validator');
const Sequelize = require("sequelize");
const { Op, fn, col } = Sequelize;
const cron = require('node-cron');
const stripe = require('stripe')('sk_test_51PvYN9AZ3KtiMZbRRnumfMRxTvGl3vq20RmJyEsj7HlLaOZJD0uYJaq94bQX2cWLWgbqEymTEYpTtPPyw1QxUp2M002EQfOIyC');
let stripeReturnUrl = `https://socket.mobytransport.com/api/stripe_connect_retrun`;

module.exports = {

    tip: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                booking_id: 'required',
                tip: 'required',
            });

            let errorsResponse = await helper.checkValidation(v)
            if (errorsResponse) {
                return helper.failed(res, errorsResponse)
            }

            await models.bookings.update({
                tip: req.body.tip,
            }, {
                where: {
                    id: req.body.booking_id
                }
            });

            let bookingDetails = await models.bookings.findOne({
                where: {
                    id: req.body.booking_id,
                },
            });

            let userData = await models.users.findOne({
                where: {
                    id: req.user.id,
                },
            });

            let amount = Math.round(parseFloat(bookingDetails.tip) * 100);

            const ephemeralKey = await stripe.ephemeralKeys.create(
                { customer: userData.stripeId },
                { apiVersion: '2020-08-27' }
            );

            const paymentIntent = await stripe.paymentIntents.create({
                amount: amount,
                currency: 'USD',
                customer: userData.stripeId,
                automatic_payment_methods: {
                    enabled: true,
                },
            });

            await bookingDetails.update({
                tip_transaction_id: paymentIntent.id,
                tip_data: paymentIntent,
                tip_stripe_status: 'pending'
            });

            let paymentResponse = {
                paymentId: paymentIntent.id,
                paymentIntent: paymentIntent.client_secret,
                ephemeralKey: ephemeralKey.secret,
                customer: userData.stripeId,
                publishableKey: 'pk_test_51PvYN9AZ3KtiMZbRkDSlo3LbmsbvUkyQOZqPAI3a3PNlkUPYi3iMc1J5QTz50yQJss2vxzh5Z5vcgkIGKHWcvn7N00E4OTkJHq'
            };

            return helper.success(res, "Payment response.", paymentResponse);

        } catch (error) {
            return helper.failed(res, error);
        }
    },

    tipStripeWebhook: async (req, res) => {
        try {
            console.log("*************************webhook response", req.body);
            console.log("*************************webhook req.body.data.object", req.body.data.object.status);

            const status = req.body.data.object.status;
            const transactionId = req.body.data.object.id;

            // Update booking status and payment information
            const updatedBooking = await models.bookings.update({
                tip_stripe_status: status,
                tip_data: req.body,
                tip_status: status === 'succeeded' ? 1 : 0
            }, {
                where: { tip_transaction_id: transactionId }
            });

            if (status === 'succeeded') {
                const booking = await models.bookings.findOne({
                    where: { tip_transaction_id: transactionId }
                });

                if (booking) {
                    const driverId = booking.driver_id;
                    const paymentAmount = booking.tip;

                    // Find the driver and update their wallet directly without commission
                    const driver = await models.users.findOne({
                        where: { id: driverId },
                        attributes: ['wallet']
                    });

                    if (driver) {
                        const currentWallet = parseFloat(driver.wallet);
                        const newWalletBalance = currentWallet + paymentAmount;

                        await models.users.update({
                            wallet: newWalletBalance
                        }, {
                            where: { id: driverId }
                        });

                        const driverData = await models.users.findOne({
                            where: { id: driverId },
                            raw: true
                        });

                        let message = `Tip received in your wallet.`;
                        let notificationData = {
                            sender_id: booking.user_id,
                            receiver_id: driverData.id,
                            user_type: driverData.role,
                            message: message,
                            type: 7,
                            booking_id: booking.id,
                            device_token: driverData.device_token,
                            device_type: driverData.device_type,
                        };

                        if (notificationData.device_token) {
                            helper.sendPushToAndroid(notificationData);
                        }

                        // Save notification to the database
                        await models.notifications.create({
                            user_by: booking.user_id,
                            user_to: driverData.id,
                            status: 0,
                            comment: message,
                            type: notificationData.type,
                            is_read: 0,
                            booking_id: booking.id,
                        });
                    }
                }
            }

            res.send(status);
        } catch (error) {
            console.error(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>", error);
            return helper.failed(res, "Error. Please try again.");
        }
    },

};
