const models = require('../models');
const helper = require('../helpers/helper')
const { Validator } = require('node-input-validator');
const jwt = require("jsonwebtoken");
const bcrypt = require("bcrypt");

module.exports = {
    userSignUp: async (req, res) => {
        try {
            const v = new Validator(req.body, {
                country_code: "required",
                phone_number: "required",
            });
            const values = JSON.parse(JSON.stringify(v));
            let errorsResponse = await helper.checkValidation(v);

            if (errorsResponse) {
                return helper.failed(res, errorsResponse);
            }
            let checkUserExist = await models.users.findOne({
                where: {
                    country_code: req.body.country_code,
                    phone_number: req.body.phone_number
                }
            });
            let is_exist = 0
            if (checkUserExist) {
                is_exist = 1
            }


            let data = {
                role: req.body.role ? req.body.role : 2 ,
                first_name: req.body.first_name ?? '',
                last_name: req.body.last_name ?? '',
                email: req.body.email ?? '',
                password: req.body.password ?? '',
                country_code: req.body.country_code ?? '',
                phone_number: req.body.phone_number ?? '',
                latitude: req.body.latitude ?? '',
                longitude: req.body.longitude ?? '',
                address: req.body.address ?? '',
                address_line_1: req.body.address_line_1 ?? '',
                address_line_2: req.body.address_line_2 ?? '',
                zip_code: req.body.zip_code ?? '',
                about: req.body.about ?? '',
                device_type: req.body.device_type ?? '',
                device_token: req.body.device_token ?? '',
            }

            if (req.files && req.files.image) {
                image = helper.fileUpload(
                    req.files.image,
                    "uploads",
                    "images"
                );
                data.image = image;
            }
            let createUser = await models.users.create(data)
            if (createUser) {

                let userInfo = await models.users.findOne({
                    where: {
                        id: createUser.id
                    },
                    raw: true
                });

                let token = jwt.sign(
                    {
                        data: {
                            id: userInfo.id,
                            email: userInfo.email,
                            name: userInfo.name,
                            type: userInfo.type,
                            device_type: userInfo.device_type,
                            device_token: userInfo.device_token,
                        },
                    },
                    process.env.CRYPTO_KEY,
                    { expiresIn: "30d" }
                );

                userInfo.token = token
                let msg = "User registered successfully!"
                return helper.success(res, msg, userInfo)
            }
        } catch (error) {
            console.log(">>>>>>error", error);
            return helper.failed(res, error)
        }
    },
};
