const models = require('../models');
const helper = require('../helpers/helper')
const { Validator } = require('node-input-validator');
const Sequelize = require("sequelize");
const { Op, fn, col } = Sequelize;
const cron = require('node-cron');
const stripe = require('stripe')('sk_test_51PvYN9AZ3KtiMZbRRnumfMRxTvGl3vq20RmJyEsj7HlLaOZJD0uYJaq94bQX2cWLWgbqEymTEYpTtPPyw1QxUp2M002EQfOIyC');
let stripeReturnUrl = `https://socket.mobytransport.com/api/stripe_connect_retrun`;

module.exports = {

    payment: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                booking_id: 'required',
                // price: 'required',
                // old_price: 'required',
                // coupon_id: 'required',
            });

            let errorsResponse = await helper.checkValidation(v)
            if (errorsResponse) {
                return helper.failed(res, errorsResponse)
            }

            let updateBooking = await models.bookings.findOne({
                where: {
                    id: req.body.booking_id,
                },
            });

            let updaeBooking = {}

            if (req.body.coupon_id) {
                updaeBooking.coupon_id = req.body.coupon_id
            }

            if (req.body.old_price) {
                updaeBooking.old_price = req.body.old_price
            }

            if (req.body.price) {
                updaeBooking.price = req.body.price
            }

            await updateBooking.update(updaeBooking);

            let bookingDetails = await models.bookings.findOne({
                where: {
                    id: req.body.booking_id,
                },
            });

            let userData = await models.users.findOne({
                where: {
                    id: req.user.id,
                },
            });

            let amount = Math.round(parseFloat(bookingDetails.price) * 100);

            const ephemeralKey = await stripe.ephemeralKeys.create(
                { customer: userData.stripeId },
                { apiVersion: '2020-08-27' }
            );

            const paymentIntent = await stripe.paymentIntents.create({
                amount: amount,
                currency: 'USD',
                customer: userData.stripeId,
                automatic_payment_methods: {
                    enabled: true,
                },
            });

            await bookingDetails.update({
                transaction_id: paymentIntent.id,
                payment: paymentIntent,
                stripe_status: 'pending'
            });

            let paymentResponse = {
                paymentId: paymentIntent.id,
                paymentIntent: paymentIntent.client_secret,
                ephemeralKey: ephemeralKey.secret,
                customer: userData.stripeId,
                publishableKey: 'pk_test_51PvYN9AZ3KtiMZbRkDSlo3LbmsbvUkyQOZqPAI3a3PNlkUPYi3iMc1J5QTz50yQJss2vxzh5Z5vcgkIGKHWcvn7N00E4OTkJHq'
            };

            return helper.success(res, "Payment response.", paymentResponse);

        } catch (error) {
            return helper.failed(res, error);
        }
    },

    // stripeWebhook: (io) => {
    //     return async (req, res) => {
    //         try {
    //             console.log("*************************webhook response", req.body);
    //             console.log("*************************webhook req.body.data.object", req.body.data.object.status);

    //             const status = req.body.data.object.status;
    //             const transactionId = req.body.data.object.id;

    //             // Update booking status and payment information
    //             const updatedBooking = await models.bookings.update({
    //                 stripe_status: status,
    //                 payment: req.body,
    //                 payment_status: status === 'succeeded' ? 1 : 0
    //             }, {
    //                 where: { transaction_id: transactionId }
    //             });

    //             if (status === 'succeeded') {
    //                 const booking = await models.bookings.findOne({
    //                     where: { transaction_id: transactionId }
    //                 });

    //                 if (booking) {
    //                     const driverId = booking.driver_id;
    //                     const paymentAmount = booking.price;

    //                     const admin = await models.users.findOne({
    //                         where: { role: 0, id: 1 },
    //                         attributes: ['commission']
    //                     });

    //                     if (admin) {
    //                         const commissionPercentage = parseFloat(admin.commission) || 5; // Default to 5% if not set

    //                         const commissionAmount = (paymentAmount * commissionPercentage) / 100;
    //                         const driverAmount = paymentAmount - commissionAmount;

    //                         // Update the driver's wallet
    //                         const driver = await models.users.findOne({
    //                             where: { id: driverId },
    //                             attributes: ['wallet']
    //                         });

    //                         if (driver) {
    //                             const currentWallet = parseFloat(driver.wallet);
    //                             const newWalletBalance = currentWallet + driverAmount;

    //                             await models.users.update({
    //                                 wallet: newWalletBalance
    //                             }, {
    //                                 where: { id: driverId }
    //                             });

    //                             // Update the admin's wallet with the commission
    //                             const adminWallet = parseFloat(admin.wallet) || 0;
    //                             const newAdminWalletBalance = adminWallet + commissionAmount;

    //                             await models.users.update({
    //                                 wallet: newAdminWalletBalance
    //                             }, {
    //                                 where: { role: 0, id: 1 }
    //                             });

    //                             // Update the commission field in the bookings table
    //                             await models.bookings.update({
    //                                 commission: commissionAmount
    //                             }, {
    //                                 where: { transaction_id: transactionId }
    //                             });

    //                             let driverSocket = await models.socket_users.findOne({
    //                                 where: { user_id: driverId },
    //                                 raw: true,
    //                             });

    //                             if (driverSocket) {
    //                                 io.to(driverSocket.socket_id).emit('ridePayment', driverAmount);
    //                             }
    //                         }
    //                     }
    //                 }
    //             }

    //             res.send(status);
    //         } catch (error) {
    //             console.error(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>", error);
    //             return helper.failed(res, "Error. Please try again.");
    //         }
    //     }
    // },

    stripeWebhook: async (req, res) => {
        try {
            console.log("*************************webhook response", req.body);
            console.log("*************************webhook req.body.data.object", req.body.data.object.status);

            const status = req.body.data.object.status;
            const transactionId = req.body.data.object.id;

            // Update booking status and payment information
            const updatedBooking = await models.bookings.update({
                stripe_status: status,
                payment: req.body,
                payment_status: status === 'succeeded' ? 1 : 0
            }, {
                where: { transaction_id: transactionId }
            });

            if (status === 'succeeded') {
                const booking = await models.bookings.findOne({
                    where: { transaction_id: transactionId }
                });

                if (booking) {
                    const driverId = booking.driver_id;
                    const paymentAmount = booking.price;

                    const admin = await models.users.findOne({
                        where: { role: 0, id: 1 },
                        attributes: ['commission']
                    });

                    if (admin) {
                        const commissionPercentage = parseFloat(admin.commission) || 5; // Default to 5% if not set

                        const commissionAmount = (paymentAmount * commissionPercentage) / 100;
                        const driverAmount = paymentAmount - commissionAmount;

                        // Update the driver's wallet
                        const driver = await models.users.findOne({
                            where: { id: driverId },
                            attributes: ['wallet']
                        });

                        if (driver) {
                            const currentWallet = parseFloat(driver.wallet);
                            const newWalletBalance = currentWallet + driverAmount;

                            await models.users.update({
                                wallet: newWalletBalance
                            }, {
                                where: { id: driverId }
                            });

                            // Update the admin's wallet with the commission
                            const adminWallet = parseFloat(admin.wallet) || 0;
                            const newAdminWalletBalance = adminWallet + commissionAmount;

                            await models.users.update({
                                wallet: newAdminWalletBalance
                            }, {
                                where: { role: 0, id: 1 }
                            });

                            // Update the commission field in the bookings table
                            await models.bookings.update({
                                commission: commissionAmount
                            }, {
                                where: { transaction_id: transactionId }
                            });

                            const driverData = await models.users.findOne({
                                where: { id: driverId },
                                raw: true
                            });

                            let message = `Payment received in your wallet.`;
                            let notificationData = {
                                sender_id: booking.user_id,
                                receiver_id: driverData.id,
                                user_type: driverData.role,
                                message: message,
                                type: 5, // Assuming type 4 represents user rating
                                booking_id: booking.id,
                                device_token: driverData.device_token,
                                device_type: driverData.device_type,
                            };

                            if (notificationData.device_token) {
                                helper.sendPushToAndroid(notificationData);
                            }

                            // Save notification to the database
                            await models.notifications.create({
                                user_by: booking.user_id,
                                user_to: driverData.id,
                                status: 0,
                                comment: message,
                                type: notificationData.type,
                                is_read: 0,
                                booking_id: booking.id,
                            });

                        }
                    }
                }
            }

            res.send(status);
        } catch (error) {
            console.error(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>", error);
            return helper.failed(res, "Error. Please try again.");
        }
    },
    // stripeWebhook: async (req, res) => {
    //     try {
    //         console.log("*************************webhook response", req.body);
    //         console.log("*************************webhook req.body.data.object", req.body.data.object.status);

    //         const status = req.body.data.object.status;
    //         const transactionId = req.body.data.object.id;

    //         const updatedBooking = await models.bookings.update({
    //             stripe_status: status,
    //             payment: req.body,
    //             payment_status: status === 'succeeded' ? 1 : 0
    //         }, {
    //             where: { transaction_id: transactionId }
    //         });

    //         if (status === 'succeeded') {
    //             const booking = await models.bookings.findOne({
    //                 where: { transaction_id: transactionId }
    //             });
    //             if (booking) {
    //                 const driverId = booking.driver_id;
    //                 const paymentAmount = booking.price;
    //             }

    //             const driver = await models.users.findOne({
    //                 where: { id: driverId },
    //                 attributes: ['wallet']
    //             });

    //             if (driver) {
    //                 const currentWallet = driver.wallet;
    //                 const newWalletBalance = parseFloat(currentWallet) + parseFloat(paymentAmount);

    //                 // Update the wallet amount in the users table
    //                 await models.users.update({
    //                     wallet: newWalletBalance
    //                 }, {
    //                     where: { id: driverId }
    //                 });
    //             }
    //         }

    //         res.send(status);
    //     } catch (error) {
    //         console.error(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>", error);
    //         return helper.failed(res, "Error. Please try again.");
    //     }
    // },

    stripeConnect: async (req, res) => {
        try {
            let account;
            let accountLink;
            let state = `?state=${req.user.id}`
            let msg;
            let userDetail = await models.users.findOne({ where: { id: req.user.id }, raw: true })

            if (userDetail && userDetail.stripeAccountHas == 0) {
                account = await stripe.accounts.create({
                    country: 'US',
                    type: 'express',
                    // email:userDetail?.email,
                    capabilities: {
                        card_payments: { requested: true },
                        transfers: { requested: true },
                    },
                    business_type: 'individual',
                });

                accountLink = await stripe.accountLinks.create({
                    account: account?.id,
                    // refresh_url: 'https://stackoverflow.com/reauth',
                    // return_url: 'https://stackoverflow.com/return',
                    refresh_url: `${stripeReturnUrl}${state}`,
                    return_url: `${stripeReturnUrl}${state}`,
                    type: 'account_onboarding',
                });
                msg = "Account Added Successfully";
            } else {
                account = await stripe.accounts.retrieve(
                    userDetail?.stripeAccountId
                );
                if (account?.charges_enabled == false) {
                    accountLink = await stripe.accountLinks.create({
                        account: account?.id,
                        //  refresh_url: 'https://example.com/reauth',
                        //  return_url: 'https://example.com/return',
                        refresh_url: `${stripeReturnUrl}${state}`,
                        return_url: `${stripeReturnUrl}${state}`,
                        type: 'account_onboarding',
                    });
                    msg = "Account Added Successfully";
                    stripeAccountHas = 0
                } else {
                    stripeAccountHas = 1
                    msg = "Account has been already added.";
                }
            }
            if (accountLink && accountLink.url) {
                await models.users.update(
                    {
                        stripeAccountId: account?.id,
                        stripeAccountHas: 1,
                    },
                    {
                        where: {
                            id: req.user.id,
                        },
                    }
                );
            }
            return helper.success(res, msg, { accountlink: accountLink ? accountLink.url : "" });
        } catch (error) {
            throw error
        }
    },

    stripe_connect_retrun: async (req, res) => {
        try {
            let stripeAccountHas;
            let state = req.query.state;
            const userData = await models.users.findOne({ where: { id: state } });
            const responseData = await stripe.accounts.retrieve(
                userData.stripeAccountId
            );
            if (responseData?.charges_enabled == false) {
                stripeAccountHas = 0
            } else {
                stripeAccountHas = 1
            }
            await models.users.update(
                {
                    stripeAccountId: responseData?.id,
                    stripeAccountHas: stripeAccountHas,
                },
                {
                    where: {
                        id: state,
                    },
                }
            );
            let msg = "ACCOUNT CONNECTED SUCCESSFULLY";
            // return
            return helper.success(res, msg, { accountStatus: 0 });
        } catch (err) {
            throw err;
        }
    },

    fetchPaymentStatus: async (req, res) => {
        try {
            let transactionId = "pi_3PwK7OAZ3KtiMZbR0do3GQZ2"
            const paymentIntent = await stripe.paymentIntents.retrieve(transactionId);
            // return paymentIntent;
            return helper.success(res, "Payment response.", paymentIntent);

        } catch (error) {
            return helper.failed(res, error);
        }
    },
};
