const models = require('../models');
const helper = require('../helpers/helper')
const { Validator } = require('node-input-validator');
const Sequelize = require("sequelize");
const { Op, fn, col } = Sequelize;

module.exports = {

    cms: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                type: "required|in:1,2,6,7" // 1=>privacy & policy, 2=>Terms & Condition, 3=>Help center, 4=>About, 5=>Third-party licenses
            });
            let errorsResponse = await helper.checkValidation(v);

            if (errorsResponse) {
                return helper.failed(res, errorsResponse);
            }

            let pages = await models.pages.findOne({
                where: {
                    id: req.body.type ? req.body.type : 1,
                }
            })

            return helper.success(res, "Cms", pages);
        } catch (error) {
            console.log(">>>>error", error);
            return helper.failed(res, error);
        }
    },

    faq: async (req, res) => {
        try {
            let faq = await models.faqs.findAll()
            return helper.success(res, "Faq", faq);
        } catch (error) {
            console.log(">>>>error", error);
            return helper.failed(res, error);
        }
    },

    contactUs: async (req, res) => {
        try {
            let data = {
                user_id: req.user.id ? req.user.id : 0,
                name: req.body.name ?? '',
                email: req.body.email ?? '',
                message: req.body.message ?? '',
            }
            await models.contact_us.create(data);
            return helper.success(res, "Contact request sent to admin successfully!", {});
        } catch (error) {
            console.log(">>>>error", error);
            return helper.failed(res, error);

        }
    }
};
