const models = require('../models');
const helper = require('../helpers/helper')
const { Validator } = require('node-input-validator');
const Sequelize = require("sequelize");
const { Op, fn, col } = Sequelize;

module.exports = {

    notificationList: async (req, res) => {
        try {
            let notifications = await models.notifications.findAll({
                include: [
                    {
                        model: models.users,
                        as: "userby"
                    },
                    {
                        model: models.users,
                        as: "userto"
                    },
                    {
                        model: models.bookings,
                    },
                ],
                where: {
                    user_to: req.user.id,
                    // is_read: 1
                },
                order: [['id', 'desc']]
            })
            await models.notifications.update({
                is_read: 0
            }, {
                where: {
                    user_to: req.user.id,
                }
            })
            return helper.success(res, "Notification listing!", notifications)
        } catch (error) {
            console.log("error", error);
            return helper.failed(res, error)
        }
    },

    clearNotification: async (req, res) => {
        try {

            let notificationDelete = await models.notifications.destroy({
                where: {
                    user_to: req.user.id
                }
            })

            return helper.success(res, "Notification cleared successfully!", {})
        } catch (error) {
            console.log("error", error);
            return helper.failed(res, error)
        }
    },

    deleteNotification: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                notification_id: "required",
            });
            let errorsResponse = await helper.checkValidation(v);

            if (errorsResponse) {
                return helper.failed(res, errorsResponse);
            }

            let notificationDelete = await models.notifications.destroy({
                where: {
                    id: req.body.notification_id
                }
            })

            return helper.success(res, "Notification deleted successfully!", notificationDelete)
        } catch (error) {
            console.log("error", error);
            return helper.failed(res, error)
        }
    },

};
