const models = require('../models');
const helper = require('../helpers/helper')
const { Validator } = require('node-input-validator');
const Sequelize = require("sequelize");
const { Op, fn, col } = Sequelize;
const saltRounds = 10;
const bcrypt = require("bcrypt");
const jwt = require("jsonwebtoken");
// bcrypt.hash("123456", 10).then((result) => {
//     console.log(">>>>>>>>result", result);
// }).catch((err) => {
//     console.log(">>>>>>>>err", err);
// });
const stripe = require('stripe')('sk_test_51PvYN9AZ3KtiMZbRRnumfMRxTvGl3vq20RmJyEsj7HlLaOZJD0uYJaq94bQX2cWLWgbqEymTEYpTtPPyw1QxUp2M002EQfOIyC');

module.exports = {

    sendEmailOtp: async (req, res) => {
        try {
            const v = new Validator(req.body, {
                email: "required|email"
            });
            const values = JSON.parse(JSON.stringify(v));
            let errorsResponse = await helper.checkValidation(v);

            if (errorsResponse) {
                return helper.failed(res, errorsResponse);
            }

            let checkUser = await models.users.findOne({
                where: {
                    email: req.body.email
                }
            })

            // if (!checkUser) {
            //     let msg = "Email does not exists"
            //     return helper.failed(res, msg)
            // }
            let otp = "1111"; // Replace with your OTP generation logic
            // let otp = Math.floor(1000 + Math.random() * 9000);

            // Update the email_otp field in the users table
            // await checkUser.update({
            //     email_otp: otp
            // });

            // Send the OTP via email
            let data = {
                email_otp: otp
            }
            await helper.send_emails(otp, req.body.email, data);
            let msg = 'Code sent to your email.';
            return helper.success(res, msg, data);
        } catch (error) {
            console.log(">>>>>>>error", error);
            return helper.failed(res, error);
        }
    },

    verifyOtp: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                email: 'required|email',
                otp: 'required',
            });
            let errorsResponse = await helper.checkValidation(v)

            if (errorsResponse) {
                return helper.failed(res, errorsResponse)
            }
            let verify = await models.users.findOne({
                where: {
                    email: req.body.email
                }
            })
            if (verify) {
                await verify.update({
                    email_otp: "",
                    is_email_verified: 1
                })
                return helper.success(res, "Verified successfully.", verify);
            } else {
                return helper.failed(res, "Error. Please enter valid otp.")
            }
        } catch (error) {
            console.log(">>>>error", error);
            return helper.failed(res, error);
        }
    },

    sendPhoneOtp: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                country_code: "required",
                phone_number: "required",
                role: "required" // 1=>driver , 2=>user
            });
            let errorsResponse = await helper.checkValidation(v);

            if (errorsResponse) {
                return helper.failed(res, errorsResponse);
            }
            let otp = "1111";

            let checkUserExist = await models.users.findOne({
                where: {
                    country_code: req.body.country_code,
                    phone_number: req.body.phone_number,
                    // role : req.body.role
                }
            });

            let otpData = {
                country_code: req.body.country_code,
                phone_number: req.body.phone_number,
                to: req.body.country_code + req.body.phone_number
            }

            let is_exist = 0
            if (checkUserExist) {
                if (checkUserExist.role != req.body.role) {
                    return helper.failed(res, "The provided role does not match the existing account for this phone number.");
                }
                is_exist = 1
                await models.users.update({
                    role: req.body.role,
                    country_code: req.body.country_code,
                    phone_number: req.body.phone_number,
                    phone_otp: otp
                }, {
                    where: {
                        id: checkUserExist.id
                    }
                })
                // helper.send_sms_twilio(otpData);
            } else {
                await models.users.create({
                    role: req.body.role,
                    country_code: req.body.country_code,
                    phone_number: req.body.phone_number,
                    phone_otp: otp
                })
                // helper.send_sms_twilio(otpData);
            }


            // Send the OTP via email
            let data = {
                otp: otp,
                is_exist: is_exist,
                country_code: req.body.country_code,
                phone_number: req.body.phone_number,
            }
            let msg = 'Code sent to your phone!';
            return helper.success(res, msg, data);
        } catch (error) {
            console.log(">>>>error", error);
            return helper.failed(res, error);
        }
    },

    verifyPhoneOtp: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                country_code: "required",
                phone_number: "required",
                otp: "required",
            });
            let errorsResponse = await helper.checkValidation(v)

            if (errorsResponse) {
                return helper.failed(res, errorsResponse)
            }

            let userData = await models.users.findOne({
                where: {
                    country_code: req.body.country_code,
                    phone_number: req.body.phone_number,
                },
                raw: true
            });

            // let verifyData = {
            //     to: req.body.country_code + req.body.phone_number,
            //     otp: req.body.otp,
            //     sid: userData.phone_otp
            // }

            // const otpVerified = await helper.verifyOtp(verifyData);

            // if (otpVerified != 1) {
            //     return helper.failed(res, "Invalid OTP. Please try again.");
            // }

            let checkUserExist = await models.users.findOne({
                where: {
                    country_code: req.body.country_code,
                    phone_number: req.body.phone_number,
                    phone_otp: req.body.otp
                }
            });

            if (checkUserExist) {

                await models.users.update(
                    {
                        phone_otp: "",
                        device_type: req.body.device_type,
                        device_token: req.body.device_token,
                        longitude: req.body.longitude,
                        latitude: req.body.latitude,
                    }, // or use '' if you prefer an empty string
                    { where: { id: checkUserExist.id } }
                );

                let checkUser = await models.users.findOne({
                    where: {
                        country_code: req.body.country_code,
                        phone_number: req.body.phone_number,
                    }
                });

                if (!checkUser.stripeId) {
                    const customer = await stripe.customers.create({
                        name: checkUser.first_name ?? '',
                        email: checkUser.email ?? '',
                    });

                    await models.users.update(
                        {
                            stripeId: customer.id,
                        },
                        {
                            where: {
                                id: checkUser.id,
                            },
                        }
                    );
                }

                let token = jwt.sign(
                    {
                        data: {
                            id: checkUser.id,
                            role: checkUser.role,
                            phone_number: checkUser.phone_number,
                            country_code: checkUser.country_code,
                            device_type: checkUser.device_type,
                            device_token: checkUser.device_token,
                        },
                    },
                    process.env.CRYPTO_KEY,
                    { expiresIn: "30d" }
                );

                let userDetails = await models.users.findOne({
                    where: {
                        id: checkUser.id,
                    },
                    raw: true,
                });
                userDetails.token = token

                return helper.success(res, "Verified successfully.", userDetails);
            } else {
                return helper.failed(res, "Error. Please enter valid otp.")
            }
        } catch (error) {
            console.log(">>>>error", error);
            return helper.failed(res, error);
        }
    },

    forgotPassword: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                email: 'required|email',
            });
            let errorsResponse = await helper.checkValidation(v)

            if (errorsResponse) {
                return helper.failed(res, errorsResponse)
            }

            let checkUser = await models.users.findOne({
                where: {
                    email: req.body.email
                }
            })

            if (!checkUser) {
                let msg = "Email does not exists"
                return helper.failed(res, msg)
            }
            let ran_token = Math.random().toString(36).substring(2, 25);

            // let email_forgot_password_hash = (checkUser.id).toString() + helper.create_auth() + helper.create_auth();
            // email_forgot_password_hash = email_forgot_password_hash.toUpperCase();
            let email_forgot_password_hash = (checkUser.id).toString() + ran_token;
            let updateUserData = await models.users.update({
                reset_token: email_forgot_password_hash
            }, {
                where: {
                    id: checkUser.id
                }
            });

            let fullUrl = req.protocol + '://' + req.get('host');
            console.log("fullUrl", fullUrl)
            let html = await helper.forgot_password_html(fullUrl, email_forgot_password_hash);
            await helper.sendEmail({
                from: 'no-reply@drop.com',
                to: checkUser.email.trim(),
                subject: 'Reset Password',
                html: html
            });
            let msg = 'Password reset link sent to your email.';
            return helper.success(res, msg, {});
        } catch (error) {
            console.log(">>>>>>>error", error);
            return helper.failed(res, error);
        }
    },

    resetPassword: async (req, res) => {
        try {
            console.log(req.params, "DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD");
            let checkData = await models.users.findOne({
                where: {
                    reset_token: req.params.id
                }
            });

            if (checkData) {
                if (checkData.reset_token.trim() == '') {
                    req.flash('error', 'Please Enter Valid Details.');
                    return res.redirect('/login');
                } else {
                    res.render('email/resetPassword', {
                        hash: checkData.reset_token, error: req.flash('error')
                    });
                }
            } else {
                req.flash('error', 'Please Enter Valid Details.');
                return res.redirect('/error');
            }
        } catch (error) {
            console.log(">>>>>>error********", error);
            return helper.failed(res, error);
        }
    },

    updatePassword: async (req, res) => {
        try {
            let hash = req.body.hash;
            let newPassword = req.body.newPassword;
            let confirmPassword = req.body.confirmPassword;

            let checkData = await models.users.findOne({
                where: {
                    reset_token: hash
                }
            });

            if (checkData) {
                if (newPassword.trim() == confirmPassword.trim()) {

                    const Hash = await bcrypt.hash(confirmPassword, 10);

                    let resetPassword = await models.users.update({
                        password: Hash
                    }, {
                        where: {
                            id: checkData.id
                        }
                    });

                    if (resetPassword) {
                        await models.users.update({
                            reset_token: 0
                        }, {
                            where: {
                                id: checkData.id
                            }
                        });
                        req.flash('msg', 'Password reset successfully.');
                        return res.redirect('/thankyou');
                    } else {
                        req.flash('error', 'Error. Please try again.');
                        res.redirect(`/api/reset-password/${hash}`);
                    }
                } else {
                    req.flash('error', 'Passwords do not match.');
                    res.redirect(`/api/reset-password/${hash}`);
                }
            } else {
                req.flash('error', 'Error. Link expired.');
                res.redirect(`/api/reset-password/${hash}`);
            }
        } catch (error) {
            console.log(">>>>>>>>error", error);
            return helper.failed(res, error);
        }
    },

    thankyou: async (req, res) => {
        res.render('thankyou', { msg: req.flash('msg'), error: req.flash('error') });
    },

    changePassword: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                old_password: 'required',
                password: 'required|different:old_password',
            });
            let errorsResponse = await helper.checkValidation(v)

            if (errorsResponse) {
                return helper.failed(res, errorsResponse)
            }

            const checkOldPassword = await models.users.findOne({
                where: {
                    id: req.user.id
                }
            })
            console.log(">>>>>>>>>>>>>>>>>>>>checkOldPassword", checkOldPassword.password);
            const newPassword = await bcrypt.hash(req.body.password, 10)
            // const checkPassword = await bcrypt.compare("123456", "$2a$10$Cbn8ivpBUGhlCUfzacQCoe1aj34F/DE8ECnYNn2iXwgxre/VQnO6e")
            const checkPassword = await helper.comparePass(req.body.old_password, checkOldPassword.password)
            // return
            if (!checkPassword) {
                let msg = 'Please enter correct old password';
                return helper.failed(res, msg);
            } else {
                let updatePassword = await models.users.update({
                    password: newPassword
                }, {
                    where: {
                        id: req.user.id
                    }
                });

                if (updatePassword) {
                    return helper.success(res, 'Password  updated successfully.', {});
                } else {
                    throw "Error...Please try again";
                }
            }

        } catch (error) {
            throw error
        }
    },

    checkPush: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                device_type: 'required',
                device_token: 'required',
                message: 'required',
            });
            let errorsResponse = await helper.checkValidation(v);

            if (errorsResponse) {
                return helper.failed(res, errorsResponse);
            }
            let pushData = {
                title: req.body.message,
                message: req.body.message,
                device_token: req.body.device_token,
                device_type: req.body.device_type,
                type: 1,
                booking_id: 1,
                sender_id: 1,
                receiver_id: 1,
                user_type: 1,
            }
            if (req.body.device_type == 1) {
                helper.sendPushToIos(pushData)
            } else if (req.body.device_type == 2) {
                helper.sendPushToAndroid(pushData)
            }
            helper.success(res, 'Push sent successfully!', {})
        } catch (error) {
            console.log(">>>>error", error);
            return helper.failed(res, error);
        }
    },

    fileUpload: async (req, res) => {
        try {
            // let v = new Validator(req.body, {
            //     image: 'required',
            // });
            // let errorsResponse = await helper.checkValidation(v)

            // if (errorsResponse) {
            //     return helper.failed(res, errorsResponse)
            // }

            if (req.files && req.files.image) {
                image = helper.fileUpload(
                    req.files.image,
                    "uploads",
                    "images"
                );

                return helper.success(res, 'Image uploaded successfully!', image)
            } else {
                return helper.success(res, 'Image uploaded successfully!', {})
            }

        } catch (error) {
            console.log(">>>>error", error);
            return helper.failed(res, error);
        }
    },

    videoUpload: async (req, res) => {
        try {
            // let v = new Validator(req.body, {
            //     video: 'required',
            //     thumbnail: 'required',
            // });
            // let errorsResponse = await helper.checkValidation(v)

            // if (errorsResponse) {
            //     return helper.failed(res, errorsResponse)
            // }

            if (req.files && req.files.video) {
                let video = helper.fileUpload(
                    req.files.video,
                    "uploads",
                    "images"
                );

                let thumbnail = helper.fileUpload(
                    req.files.thumbnail,
                    "uploads",
                    "images"
                );

                let response = {
                    video,
                    thumbnail
                }

                return helper.success(res, 'Video uploaded successfully!', response)
            } else {
                return helper.success(res, 'Video uploaded successfully!', {})
            }

        } catch (error) {
            console.log(">>>>error", error);
            return helper.failed(res, error);
        }
    },

    clearNotification: async (req, res) => {
        try {
            where = {}
            if (req.user.role == 1) {
                where.artist_id = req.user.id
            } else if (req.user.role == 2) {
                where.studio_id = req.user.id
            } else {
                where.user_id = req.user.id
            }

            let notificationDelete = await models.artist_notifications.destroy({
                where: where
            })

            return helper.success(res, "Notification cleared successfully!", notificationDelete)
        } catch (error) {
            console.log("error", error);
            return helper.failed(res, error)
        }
    },

    deleteNotification: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                notification_id: "required",
            });
            let errorsResponse = await helper.checkValidation(v);

            if (errorsResponse) {
                return helper.failed(res, errorsResponse);
            }

            let notificationDelete = await models.artist_notifications.destroy({
                where: {
                    id: req.body.notification_id
                }
            })

            return helper.success(res, "Notification deleted successfully!", notificationDelete)
        } catch (error) {
            console.log("error", error);
            return helper.failed(res, error)
        }
    },

    notificationList: async (req, res) => {
        try {
            console.log("user_to: req.user.id,", req.user.id)
            let notifications = await models.artist_notifications.findAll({
                include: [
                    {
                        model: models.users,
                        as: "userby"
                    },
                    {
                        model: models.users,
                        as: "userto"
                    },
                    {
                        model: models.bookings,
                    },
                    {
                        model: models.posts,
                    },
                    {
                        model: models.orders,
                        include: [
                            {
                                model: models.order_histories,
                                include: [
                                    {
                                        model: models.products,
                                        include: [
                                            {
                                                model: models.product_images
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                model: models.addresses
                            }
                        ]
                    },
                ],
                where: {
                    user_to: req.user.id,
                    // is_read: 1
                },
                order: [['id', 'desc']]
            })
            await models.artist_notifications.update({
                is_read: 0
            }, {
                where: {
                    user_to: req.user.id,
                }
            })
            return helper.success(res, "Notification listing!", notifications)
        } catch (error) {
            console.log("error", error);
            return helper.failed(res, error)
        }
    },

    logout: async (req, res) => {
        try {
            await models.users.update({
                device_token: "",
                // is_notification : 0,
                device_type: 0,
            }, {
                where: {
                    id: req.user.id
                }
            })

            return helper.success(res, "Signout successfully!", {})
        } catch (error) {
            return helper.failed(res, error)
        }
    },

    setNewPassword: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                user_id: 'required',
                password: 'required',
            });
            let errorsResponse = await helper.checkValidation(v)

            if (errorsResponse) {
                return helper.failed(res, errorsResponse)
            }

            const newPassword = await bcrypt.hash(req.body.password, 10)

            await models.users.update({
                password: newPassword,
                device_type: req.body.device_type ? req.body.device_type : '',
                device_token: req.body.device_token ? req.body.device_token : '',
            }, {
                where: {
                    id: req.body.user_id
                }
            });

            const checkUser = await models.users.findOne({
                where: {
                    id: req.body.user_id
                },
                raw: true
            })

            let token = jwt.sign(
                {
                    data: {
                        id: checkUser.id,
                        email: checkUser.email,
                        name: checkUser.name,
                        type: checkUser.type,
                        device_type: checkUser.device_type,
                        device_token: checkUser.device_token,
                    },
                },
                process.env.CRYPTO_KEY,
                { expiresIn: "30d" }
            );

            let userDetails = await models.users.findOne({
                where: {
                    id: checkUser.id,
                },
                raw: true,
            });

            userDetails.token = token

            if (userDetails) {
                return helper.success(res, 'Password  updated successfully.', userDetails);
            } else {
                throw "Error...Please try again";
            }

        } catch (error) {
            throw error
        }
    },

    updateNotificationStatus: async (req, res) => {
        try {
            let data = {}

            if (req.body.is_notification) {
                data.is_notification = req.body.is_notification
            }

            let updateNotification = await models.users.update(data,
                {
                    where: {
                        id: req.user.id
                    }
                })

            let userDetails = await models.users.findOne({
                where: {
                    id: req.user.id
                }
            })
            return helper.success(res, "Notifications status updated successfully!", userDetails)
        } catch (error) {
            console.log("error>>>>>", error)
            return helper.failed(res, error)
        }
    },

    deleteAccount: async (req, res) => {
        try {
            await models.users.destroy({
                where: {
                    id: req.user.id
                }
            })

            return helper.success(res, "Account deleted successfully!", {})
        } catch (error) {
            console.log("error>>>>>", error)
            return helper.failed(res, error)
        }
    }
};
