const models = require('../models');
const helper = require('../helpers/helper')
const { Validator } = require('node-input-validator');
const Sequelize = require("sequelize");
const { Op, fn, col } = Sequelize;
const saltRounds = 10;
const bcrypt = require("bcrypt");
const jwt = require("jsonwebtoken");

module.exports = {
    couponList: async (req, res) => {
        try {
            const currentDate = new Date().toISOString().split('T')[0];

            const appliedCoupons = await models.bookings.findAll({
                where: {
                    user_id: req.user.id, // Assuming req.user.id contains the current user's ID
                    coupon_id: {
                        [Op.ne]: 0
                    }
                },
                attributes: ['coupon_id'],
                raw: true
            });

            // Extract applied coupon IDs
            const appliedCouponIds = appliedCoupons.map(booking => booking.coupon_id);

            const couponList = await models.coupons.findAll({
                where: {
                    expiry_date: {
                        [Op.gte]: currentDate
                    },
                    id: {
                        [Op.notIn]: appliedCouponIds
                    }
                }
            });

            // let couponList = await models.coupons.findAll({
            //     where: {
            //         expiry_date: {
            //             [Op.gte]: currentDate
            //         }
            //     }
            // });

            return helper.success(res, "Coupon list!", couponList);
        } catch (error) {
            console.log("Coupon list error", error);
            return helper.failed(res, error);
        }
    },

    couponApply: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                booking_id: 'required',
                promo_id: 'required',
            });
    
            let errorsResponse = await helper.checkValidation(v);
            if (errorsResponse) {
                return helper.failed(res, errorsResponse);
            }
    
            let bookingDetails = await models.bookings.findOne({
                where: {
                    id: req.body.booking_id
                },
                raw: true
            });
    
            let promoDetails = await models.coupons.findOne({
                where: {
                    id: req.body.promo_id
                },
                raw: true
            });
    
            if (!bookingDetails || !promoDetails) {
                return helper.failed(res, "Booking or Promo details not found");
            }
    
            // Convert booking distance from miles to kilometers
            let bookingDistanceInKm = bookingDetails.distance * 1.60934;  // 1 mile = 1.60934 kilometers
    
            if (bookingDistanceInKm >= promoDetails.distance) {
                return helper.success(res, "Coupon applicable!", {});
            } else {
                return helper.failed(res, "Coupon cannot be applied. Distance does not meet the requirement.");
            }
        } catch (error) {
            console.log("Coupon apply error", error);
            return helper.failed(res, error);
        }
    }
    

};
