const models = require('../models');
const helper = require('../helpers/helper')
const { Validator } = require('node-input-validator');
const Sequelize = require("sequelize");
const { Op, fn, col } = Sequelize;

module.exports = {

    addBankAccount: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                account_holder_name: 'required',
                account_number: 'required',
            });

            let errorsResponse = await helper.checkValidation(v)
            if (errorsResponse) {
                return helper.failed(res, errorsResponse)
            }

            let checkAccountExist = await models.banks.findOne({
                where: {
                    account_number: req.body.account_number
                }
            })

            if (checkAccountExist) {
                return helper.failed(res, "This account number is already added!")
            }

            let bank = {
                user_id: req.user.id,
                bank_name: req.body.bank_name ? req.body.bank_name : '',
                account_holder_name: req.body.account_holder_name ? req.body.account_holder_name : '',
                account_number: req.body.account_number ? req.body.account_number : '',
                ifsc_code: req.body.ifsc_code ? req.body.ifsc_code : '',
            }
            let createBankAccount = await models.banks.create(bank);

            createBankAccount = createBankAccount.toJSON();
            delete createBankAccount.createdAt;
            delete createBankAccount.updatedAt;
            return helper.success(res, "Bank account added successfully.", createBankAccount);

        } catch (error) {
            return helper.failed(res, error);
        }
    },

    bankAccountList: async (req, res) => {
        try {
            let accountList = await models.banks.findAll({
                where: {
                    user_id: req.user.id,
                    status: 1,
                }
            })

            return helper.success(res, "Account list successfully.", accountList);

        } catch (error) {
            return helper.failed(res, error);
        }
    },

    bankDelete: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                bank_id: 'required',
            });

            let errorsResponse = await helper.checkValidation(v)
            if (errorsResponse) {
                return helper.failed(res, errorsResponse)
            }

            let update = await models.banks.update({
                status: 0
            },
                {
                    where: {
                        id: req.body.bank_id,
                        user_id: req.user.id
                    }
                }
            )

            return helper.success(res, "Account deleted successfully.", update);

        } catch (error) {
            return helper.failed(res, error);
        }
    },

    setDefaultBank: async (req, res) => {
        try {
            let v = new Validator(req.body, {
                bank_id: 'required',
            });

            let errorsResponse = await helper.checkValidation(v)
            if (errorsResponse) {
                return helper.failed(res, errorsResponse)
            }

            await models.banks.update(
                { is_default: 0 },
                {
                    where: { user_id: req.user.id }
                }
            );

            let updateDefault = await models.banks.update(
                {
                    is_default: 1
                }, {
                where: {
                    id: req.body.bank_id,
                    user_id: req.user.id
                }
            }
            )

            return helper.success(res, "Bank default set successfully.", {});
        } catch (error) {
            console.log("error====", error);
            return helper.failed(res, error);
        }
    }

};
