const models = require('../models');
const helper = require('../helpers/helper')
const { Validator } = require('node-input-validator');
const jwt = require("jsonwebtoken");
const bcrypt = require("bcrypt");
module.exports = {
    checkEmail: async (req, res) => {
        const v = new Validator(req.body, {
            email: "required"
        });
        console.log(">>>>>req.body", req.body);
        const values = JSON.parse(JSON.stringify(v));
        let errorsResponse = await helper.checkValidation(v);
        if (errorsResponse) {
            return helper.failed(res, errorsResponse);
        }

        let checkUser = await models.users.findOne({
            where: {
                email: req.body.email
            }
        })

        let otp = "1111"; // Replace with your OTP generation logic
        // let otp = Math.floor(1000 + Math.random() * 9000);
        let data = {
            email_otp: otp
        }

        if (checkUser) {
            if (checkUser && checkUser.device_type == 3) {
                await helper.send_emails(otp, req.body.email, data);
                await models.users.update({ email_otp: otp }, {
                    where: {
                        email: req.body.email
                    }
                });

                let userData = await models.users.findOne({
                    where: {
                        email: req.body.email
                    }
                })
                return helper.success(res, "Otp sent to email", userData);
            } else {
                return helper.success(res, "Email already exists", checkUser);
            }

        } else {
            // Send the OTP via email
            await helper.send_emails(otp, req.body.email, data);

            let msg = 'Code sent to your email.';
            return helper.success(res, msg, data);
        }
    },

    signIn: async (req, res) => {
        try {
            const v = new Validator(req.body, {
                email: "required",
                password: "required",
                device_type: "required",
                device_token: "required",
            });
            console.log(">>>>>req.body", req.body);
            const values = JSON.parse(JSON.stringify(v));
            let errorsResponse = await helper.checkValidation(v);


            if (errorsResponse) {
                return helper.failed(res, errorsResponse);
            }

            let checkUser = await models.users.findOne({
                where: {
                    email: req.body.email
                }
            })

            if (checkUser) {
                if (checkUser.is_email_verified != 1) {
                    return helper.failed(res, "Please verify your email address.");
                }

                if (checkUser.status != 1) {
                    return helper.failed(res, "Sorry your account is not activated yet. Please contact to admin");
                }
                // const isMatch = await helper.comparePass(
                //     req.body.password,
                //     checkUser.password
                // );
                const isMatch = await bcrypt.compare(
                    req.body.password,
                    checkUser.password
                );
                if (!isMatch) {
                    let msg = "Incorrect email or password";
                    return helper.failed(res, msg);
                }

                await models.users.update(
                    {
                        device_type: req.body.device_type,
                        device_token: req.body.device_token,
                        longitude: req.body.longitude,
                        latitude: req.body.latitude,
                    },
                    { where: { id: checkUser.id } }
                );

                let token = jwt.sign(
                    {
                        data: {
                            id: checkUser.id,
                            email: checkUser.email,
                            name: checkUser.name,
                            type: checkUser.type,
                            device_type: checkUser.device_type,
                            device_token: checkUser.device_token,
                        },
                    },
                    process.env.CRYPTO_KEY,
                    { expiresIn: "30d" }
                );

                let userDetails = await models.users.findOne({
                    where: {
                        id: checkUser.id,
                    },
                    raw: true,
                });
                userDetails.token = token
                let msg = "login Successfully";
                return helper.success(res, "Login successfully.", userDetails);
            } else {
                let msg = "incorrect email and password";
                return helper.failed(res, msg);
            }
        } catch (error) {
            console.log(">>>>>>>>", error);
            return helper.failed(res, error);
        }
    }

}